unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons, Winsock, IdBaseComponent,
  IdComponent, IdTCPServer, IdIOHandler, IdIOHandlerStream,
  IdIOHandlerSocket, IdServerIOHandler, IdServerIOHandlerSocket,
  IdThreadMgr, IdThreadMgrPool, IdThread;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    IdTCPServer1: TIdTCPServer;
    procedure IdTCPServer1Execute(AThread: TIdPeerThread);
  private
    { Private declarations }
    FConnection: TIdTCPServerConnection;
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;
  fwsaData:WSADATA;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.IdTCPServer1Execute(AThread: TIdPeerThread);
var
   _ms: TMemoryStream;
   _sz: integer;
   _s: string;
begin
   AThread.Connection.ReadBuffer(_sz, 4);
   SetLength(_s, _sz);
   AThread.Connection.ReadBuffer(_s[1], _sz);

   _ms:= TMemoryStream.Create;
   try
      { write the msg data }
      _ms.Write(_s[1], length(_s));
      { go to begining of the file }
      _ms.Position:= 0;

      { decode the stream }
      ReceiveData(_ms);
   finally
      _ms.Free;
   end;
end;

end.
